//#include <afx.h>
#include <mbstring.h>
#include "umf.h"
#define _DLL
/***********    4442    ************/
#define   CARD4442SENTTITLE1    0x02
#define   CARD4442SENTTITLE2    0x05
/***********   CPU DEF  ************/
#define   CPUSENTTITLE1         0x02
#define   CPUSENTTITLE2         0x02 
#define   CPUOVERFLOWTITLE1     0x82


//1
DLLSPEC int _stdcall fw_init(int port,long baud)
{
	if((port<=19)&&(port>=0))//COM ports
	{
		return -16;
	}
	else if(port==100)
	{
		GUID   mguid;
		HidD_GetHidGuid(&mguid);
		HDEVINFO hDevInfo=SetupDiGetClassDevs(&mguid,NULL,0,
			DIGCF_PRESENT|DIGCF_DEVICEINTERFACE);
		//search usb port
		SP_DEVICE_INTERFACE_DATA strInterfaceData;
		strInterfaceData.cbSize=sizeof(strInterfaceData);
		//
		for(int i=0;;i++)
		{
			BOOL bSuccess=SetupDiEnumDeviceInterfaces(hDevInfo,NULL,
				&mguid,i,&strInterfaceData);
			if(!bSuccess)
			{
				SetupDiDestroyDeviceInfoList(hDevInfo);
				return 0x20;//failed to find usb port
			}
			unsigned long Length=0;
			SetupDiGetDeviceInterfaceDetail(hDevInfo,&strInterfaceData,
			NULL,0,&Length,NULL);
			PSP_DEVICE_INTERFACE_DETAIL_DATA strDetailData=
				(PSP_DEVICE_INTERFACE_DETAIL_DATA)malloc(Length);
			strDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
			if(!SetupDiGetDeviceInterfaceDetail(hDevInfo,&strInterfaceData,
				strDetailData,Length,NULL,NULL))
			{
				return 0x20;//path error
			}
			HANDLE hDev;
			hDev=CreateFile(strDetailData->DevicePath,GENERIC_READ|GENERIC_WRITE,
				FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,
				NULL);
			if(hDev==INVALID_HANDLE_VALUE)
			{
				continue ;//open comport failed
			}
			else
			{
				return (int)hDev;
			}
		}

	}
	else
	{
		return 0x7c;
	}
}
//2
DLLSPEC int _stdcall fw_exit(int icdev)
{
	icdev=0;
	return 0;
}
//3
DLLSPEC int _stdcall fw_card(int icdev,unsigned char _Mode,unsigned long *_Snr)
{
	
	unsigned char size;
    unsigned int *tagtype;

	if(fw_request(icdev,_Mode,tagtype)==0)
	{
		if(fw_anticoll(icdev,0,_Snr)==0)
		{
			
			if(fw_select(icdev,*_Snr,&size)==0)
			{
				return 0;
			}
			else return 0x20;

		}
		else return 0x20;
	}
	else 
		return 0x20;
		
}
//4
DLLSPEC int _stdcall fw_request(int icdev,unsigned char _Mode,unsigned int *TagType)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		memset(OutReport,0,255);
		temp[0]=0x00;
		temp[1]=0x2;
		temp[2]=0x2;
		temp[3]=0x41;
		temp[4]=0x1;
		temp[5]=_Mode;
		temp[6]=temp[2]^temp[3]^temp[4]^temp[5];

		BOOL flag=FALSE;
		flag=HidD_SetFeature(hDev,temp,0x21);

		flag=HidD_GetFeature(hDev,OutReport,0x21);


		if(!OutReport[3])
			return (int)OutReport[3];

		unsigned char strtagType[2];
		unsigned int iTagtype;
		strtagType[0]=OutReport[6];
		strtagType[1]=OutReport[5];
		
		iTagtype=strtol((char *)strtagType,NULL,16);
		*TagType=iTagtype;

		return 0;
	}
	else 
		return 0x20;
}
//5
DLLSPEC int _stdcall fw_anticoll(int icdev,unsigned char _Bcnt,unsigned long *_Snr)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		OutReport[0]=0;
		memset(temp,0,255);

		temp[0]=0x00;
		temp[1]=0x2;
		temp[2]=0x2;
		temp[3]=0x42;
		temp[4]=0x5;

		//data
		temp[5]=_Bcnt;
		temp[6]=0xb4;
		temp[7]=0x00;
		temp[8]=0x00;
		temp[9]=0x00;

		temp[10]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6]^temp[7]^temp[8]^temp[9];
	/*	temp[11]=0x00;
		temp[12]=0x00;
		temp[13]=0x00;
		temp[14]=0x02;
		temp[15]=0x41;
		temp[16]=0x01;*/
		
		BOOL flag=FALSE;
		flag=HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return OutReport[3];
		
		char *str,*pstr;
		str=( char*)malloc(32);
		pstr=str;
		for(int k=8;k>4;k--)
		{
			BYTE bt=*(char*)(OutReport+k);//ַ 
			int i=(int)bt;
			itoa(i,str,16);
			str+=2;
		}
		
		*_Snr=strtol(pstr,NULL,16);
		
		int ErrorType;
		ErrorType=GetLastError();
		if(ErrorType!=0)
			return ErrorType;
		return 0;
	}
	return 0x20;
}
//6
DLLSPEC int _stdcall fw_select(int icdev,unsigned long _Snr,unsigned char *_Size)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		OutReport[0]=0;
		memset(temp,0,255);
		temp[0]=0x00;
		temp[1]=0x2;
		temp[2]=0x2;
		temp[3]=0x43;
		temp[4]=0x4;

		unsigned char cardstr[32];
		itoa((int)_Snr,(char *)cardstr,16);

		unsigned char ptemp[4],*pstr;
		memset(ptemp,0,4);
		pstr=cardstr;
		for(int j=3;j>-1;j--)
		{
			unsigned char buffer[2];
			for(int i=0;i<2;i++)
			{
				buffer[i]=*pstr;
				pstr++;
			}
			ptemp[j]=(unsigned char)strtol((char *)buffer,NULL,16);
		}

		temp[5]=ptemp[0];
		temp[6]=ptemp[1];
		temp[7]=ptemp[2];
		temp[8]=ptemp[3];

		temp[9]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6]^temp[7]^temp[8];


		BOOL flag=FALSE;
		flag=HidD_SetFeature(hDev,temp,0x21);
		flag=HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return OutReport[3];
		int ErrorType;
		ErrorType=GetLastError();
		if(ErrorType!=0)
			return ErrorType;
		return 0;
	}
	else 
		return 0x20;
}
//7
DLLSPEC int _stdcall fw_load_key(int icdev,unsigned char _Mode,
				unsigned char _SecNr,unsigned char *_NKey)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		OutReport[0]=0;
		memset(temp,0,255);
		temp[0]=0x00;
		temp[1]=0x2;
		temp[2]=0x2;
		temp[3]=0x4c;
		temp[4]=0x12;
		temp[5]=_Mode;
		temp[6]=_SecNr;

		for(int i=15;i<21;i++)
		{
			temp[i]=*(_NKey++);
		}
		temp[23]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6]^temp[15]^temp[16]^temp[17]^temp[18]^temp[19]^temp[20];
		BOOL flag;
		flag=HidD_SetFeature(hDev,temp,0x21);
		flag=HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return OutReport[3];

		int ErrorType=GetLastError();
		if(ErrorType!=0)
			return ErrorType;
		return 0;//return scuess
	}
	else
		return 0x20;//open endpoint failed
}
//8
DLLSPEC int _stdcall fw_authentication(int icdev,unsigned char _Mode,
									   unsigned char _SecNr)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		OutReport[0]=0;
		memset(temp,0,255);
		temp[0]=0x00;
		temp[1]=0x2;
		temp[2]=0x2;
		temp[3]=0x44;
		temp[4]=0x2;
		temp[5]=_Mode;
		temp[6]=_SecNr;
		temp[7]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6];
		temp[8]=0x00;
		BOOL flag=FALSE;
		flag=HidD_SetFeature(hDev,temp,0x21);
		flag=HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return OutReport[3];
		int ErrorType;
		ErrorType=GetLastError();
		if(ErrorType!=0)
			return ErrorType;
		return 0;
	}
	else
		return 0x20;
}
//9
DLLSPEC int _stdcall fw_read(int icdev,unsigned char _Adr,unsigned char *_Data)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		OutReport[0]=0;
		memset(temp,0,255);

		if((int)_Adr%4==0)
		{
			temp[0]=0x00;
			temp[1]=0x2;
			temp[2]=0x2;
			temp[3]=0x46;
			temp[4]=0x01;
			temp[5]=_Adr;
			temp[6]=temp[2]^temp[3]^temp[4]^temp[5];

		}
		else if((int)_Adr>0&&(int)_Adr<64)
		{
			switch((int)_Adr%4)
			{
			case 1:
				temp[18]=0x88;
				break;
			case 2:
				temp[18]=0x1c;
				break;
			case 3:
				temp[19]=0x40;
				break;
			default:
				break;
			}
			temp[0]=0x00;
			temp[1]=0x2;
			temp[2]=0x2;
			temp[3]=0x46;
			temp[4]=0x01;
			temp[5]=_Adr;
			temp[6]=temp[2]^temp[3]^temp[4]^temp[5];


		}
		else 
			return (0x7c);     //preferences  error
	
		BOOL flag=FALSE;
		flag=HidD_SetFeature(hDev,temp,0x21);
		flag=HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return OutReport[3];//call failed
		else
		{                       //call success
			for(int i=0;i<16;i++)
			{
				*(_Data++)=OutReport[5+i];
			}

		}

		int Error;
		Error=GetLastError();
		if(Error)
			return Error;

		return 0;//Success
	}
	else 
		return (0x20);
	
}
//9.1
DLLSPEC __int16 __stdcall fw_read_hex(HANDLE icdev,unsigned char _Adr,char *_Data)
{
	if(icdev)
	{
		unsigned char temp[255];
		unsigned char OutReport[255];
		OutReport[0]=0;
		memset(temp,0,255);
		if((int)_Adr==0)
			return (0x7c);//preferences  error
		else if((int)_Adr%4==0)
		{
			temp[0]=0x00;
			temp[1]=0x2;
			temp[2]=0x2;
			temp[3]=0x46;
			temp[4]=0x01;
			temp[5]=_Adr;
			temp[6]=temp[2]^temp[3]^temp[4]^temp[5];
			//temp[7]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6];
			temp[7]=0x17;
			temp[8]=0xbe;
			temp[9]=0x68;
			temp[10]=0xac;
			temp[14]=0x92;
			temp[15]=0x01;
			temp[16]=0x0b;
			temp[26]=0x94;
			temp[27]=0xeb;
			temp[28]=0x12;
			temp[30]=0x21;

		}
		else if((int)_Adr>0&&(int)_Adr<64)
		{
			switch((int)_Adr%4)
			{
			case 1:
				temp[18]=0x88;
				break;
			case 2:
				temp[18]=0x1c;
				break;
			case 3:
				temp[19]=0x40;
				break;
			default:
				break;
			}
			temp[0]=0x00;
			temp[1]=0x2;
			temp[2]=0x2;
			temp[3]=0x46;
			temp[4]=0x01;
			temp[5]=_Adr;
			temp[6]=temp[2]^temp[3]^temp[4]^temp[5];
			//temp[7]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6];
			temp[7]=0x08;
			temp[8]=0x02;
			temp[10]=0x80;
			temp[11]=0x01;
		//	temp[18]=0x88;
			temp[19]=0xec;
			temp[20]=0x12;
			temp[22]=0x01;
			temp[26]=0x64;
			temp[27]=0xea;
			temp[28]=0x12;
			temp[30]=0xb5;
			temp[31]=0x83;
			temp[32]=0x42;
		}
		else 
			return (0x7c);//preferences  error
		BOOL flag=FALSE;
		flag=HidD_SetFeature(icdev,temp,0x21);
		flag=HidD_GetFeature(icdev,OutReport,0x21);
		if(OutReport[3])
			return OutReport[3];
		else
		{                       //call success
			for(int i=0;i<16;i++)
			{
				*(_Data++)=OutReport[5+i];
			}
			
		}
		int Error;
		Error=GetLastError();
		if(Error)
			return Error;

		return 0;//Success
	}
	else
		return (0x20);
	
}
//10
DLLSPEC int _stdcall fw_write(int icdev,unsigned char _Adr,unsigned char *_Data)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		OutReport[0]=0;
		memset(temp,0,255);
		temp[0]=0x00;
		temp[1]=0x2;
		temp[2]=0x2;
		temp[3]=0x47;
		temp[4]=0x11;
		temp[5]=_Adr;
		int i=6;
		do
		{
			temp[i++]=*(_Data++);
		}
		while(_Data&&(i<22));
		if(!_Data)
			return (0x7c);//preferces error

		temp[22]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6]^temp[7]^temp[8]^temp[9]^\
			temp[10]^temp[11]^temp[12]^temp[13]^temp[14]^temp[15]^temp[16]^\
			temp[17]^temp[18]^temp[19]^temp[20]^temp[21];

		
		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed


		return (0);//call success
	}
	else
		return (0x20);//open endpoint error
	
}
//10.1
DLLSPEC __int16 __stdcall fw_write_hex(HANDLE icdev,unsigned char _Adr,char *_Data)
{
	if(icdev)
	{
		
		unsigned char temp[255];
		unsigned char OutReport[255];
		OutReport[0]=0;
		memset(temp,0,255);
		temp[0]=0x00;
		temp[1]=0x2;
		temp[2]=0x2;
		temp[3]=0x47;
		temp[4]=0x11;
		temp[5]=_Adr;
		int i=6;
		do
		{
			temp[i++]=*(_Data++);
		}
		while(_Data&&(i<22));
		if(!_Data)
			return (0x7c);//preferces error

		temp[22]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6]^temp[7]^temp[8]^temp[9]^\
			temp[10]^temp[11]^temp[12]^temp[13]^temp[14]^temp[15]^temp[16]^\
			temp[17]^temp[18]^temp[19]^temp[20]^temp[21];
		
		HidD_SetFeature(icdev,temp,0x21);
		HidD_GetFeature(icdev,OutReport,0x21);
		if(OutReport[3])
			return OutReport[3];//call failed
		
		
		return 0;//call success
	}
	else
		return (0x20);//open endpoint error

}
//11
DLLSPEC int _stdcall fw_halt(int icdev)
{
	if(icdev)
	{	
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		OutReport[0]=0;
		memset(temp,0,255);
		temp[0]=0x00;
		temp[1]=0x2;
		temp[2]=0x2;
		temp[3]=0x45;
		temp[4]=0x00;
		temp[5]=temp[2]^temp[3]^temp[4];
		
		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return OutReport[3];//call failed
		
		
		return 0;//call success
	}
	else
		return (0x20);//open endpoint error
}
//12
DLLSPEC int _stdcall fw_des(unsigned char *key,unsigned char *sour,
				   unsigned char *dest,__int16 m)
{
	if(m==0)
	{
		__int16 ip[]=
		{
			58,50,42,34,26,18,10,2,
				60,52,44,36,28,20,12,4,
				62,54,46,38,30,22,14,6,
				64,56,48,40,32,24,16,8,
				57,49,41,33,25,17,9 ,1,
				59,51,43,35,27,19,11,3,
				61,53,45,37,29,21,13,5,
				63,55,47,39,31,23,15,7
		};
		unsigned char fp[] =
		{
			40,8,48,16,56,24,64,32,
				39,7,47,15,55,23,63,31,
				38,6,46,14,54,22,62,30,
				37,5,45,13,53,21,61,29,
				36,4,44,12,52,20,60,28,
				35,3,43,11,51,19,59,27,
				34,2,42,10,50,18,58,26,
				33,1,41, 9,49,17,57,25
		};
		__int16 e[]=
		{
			32,1 ,2 ,3 ,4 ,5 ,
				4 ,5 ,6 ,7 ,8 ,9 ,
				8, 9 ,10,11,12,13,
				12,13,14,15,16,17,
				16,17,18,19,20,21,
				20,21,22,23,24,25,
				24,25,26,27,28,29,
				28,29,30,31,32,1
		};
		__int16 p[]=
		{
			16,7 ,20,21,
				29,12,28,17,
				1 ,15,23,26,
				5 ,18,31,10,
				2 ,8 ,24,14,
				32,27,3 ,9,
				19,13,30,6,
				22,11,4 ,25
		};
		unsigned char si[8][64] =
		{
			{14,4 ,13,1 ,2 ,15,11,8 ,3 ,10,6 ,12,5 ,9 ,0 ,7 ,
				0 ,15,7 ,4 ,14,2 ,13,1 ,10,6 ,12,11,9 ,5 ,3 ,8 ,
				4 ,1 ,14,8 ,13,6 ,2 ,11,15,12,9 ,7 ,3 ,10,5 ,0 ,
				15,12,8 ,2 ,4 ,9 ,1 ,7 ,5 ,11,3 ,14,10,0 ,6 ,13},
				
			{15,1 ,8 ,14,6 ,11,3 ,4 ,9 ,7 ,2 ,13,12,0 ,5 ,10,
			3, 13,4 ,7 ,15,2 ,8 ,14,12,0 ,1 ,10,6 ,9 ,11,5 ,
			0, 14,7 ,11,10,4 ,13,1 ,5 ,8 ,12,6 ,9 ,3 ,2 ,15,
			13,8 ,10,1 ,3 ,15,4 ,2 ,11,6 ,7 ,12,0 ,5 ,14,9 },
			
			{10,0 ,9 ,14,6 ,3 ,15,5 ,1 ,13,12,7 ,11,4 ,2 ,8 ,
			13,7 ,0 ,9 ,3 ,4 ,6 ,10,2 ,8 ,5 ,14,12,11,15,1 ,
			13,6 ,4 ,9 ,8 ,15,3 ,0 ,11,1 ,2 ,12,5 ,10,14,7 ,
			1 ,10,13,0 ,6 ,9 ,8 ,7 ,4 ,15,14,3 ,11,5 ,2 ,12},
			
			{7 ,13,14,3 ,0 ,6 ,9 ,10,1 ,2 ,8 ,5 ,11,12,4 ,15,
			13,8 ,11,5 ,6 ,15,0 ,3 ,4 ,7 ,2 ,12,1 ,10,14,9 ,
			10,6 ,9 ,0 ,12,11,7 ,13,15,1 ,3 ,14,5 ,2 ,8 ,4 ,
			3 ,15,0 ,6 ,10,1 ,13,8 ,9 ,4 ,5 ,11,12,7 ,2 ,14},
			
			{2 ,12,4 ,1 ,7 ,10,11,6 ,8 ,5 ,3 ,15,13,0 ,14,9 ,
			14,11,2 ,12,4 ,7 ,13,1 ,5 ,0 ,15,10,3 ,9 ,8 ,6,
			4 ,2 ,1 ,11,10,13,7 ,8 ,15,9 ,12,5 ,6 ,3 ,0 ,14,
			11,8 ,12,7 ,1 ,14,2 ,13,6 ,15,0 ,9 ,10,4 ,5 ,3 },
			
			{12,1 ,10,15,9 ,2 ,6 ,8 ,0 ,13,3 ,4 ,14,7 ,5 ,11,
			10,15,4 ,2 ,7 ,12,9 ,5 ,6 ,1 ,13,14,0 ,11,3 ,8 ,
			9 ,14,15,5 ,2 ,8 ,12,3 ,7 ,0 ,4 ,10,1 ,13,11,6 ,
			4 ,3 ,2 ,12,9 ,5 ,15,10,11,14,1 ,7 ,6 ,0 ,8 ,13},
			
			{4 ,11,2 ,14,15,0 ,8 ,13,3 ,12,9 ,7 ,5 ,10,6 ,1 ,
			13,0 ,11,7 ,4 ,9 ,1 ,10,14,3 ,5 ,12,2 ,15,8 ,6 ,
			1 ,4 ,11,13,12,3 ,7 ,14,10,15,6 ,8 ,0 ,5 ,9 ,2 ,
			6 ,11,13,8 ,1 ,4 ,10,7 ,9 ,5 ,0 ,15,14,2 ,3 ,12},
			
			{13,2 ,8 ,4 ,6 ,15,11,1 ,10,9 ,3 ,14,5 ,0 ,12,7 ,
			1 ,15,13,8 ,10,3 ,7 ,4 ,12,5 ,6 ,11,0 ,14,9 ,2 ,
			7 ,11,4 ,1 ,9 ,12,14,2 ,0 ,6 ,10,13,15,3 ,5 ,8 ,
			2 ,1 ,14,7 ,4 ,10,8 ,13,15,12,9 ,0 ,3 ,5 ,6 ,11}
		};
		
		unsigned char src[1000][8],src_bit[64],ipt[64];
		unsigned char et[48],pt1[32],pt2[32],r[32],l[32],*pt;
		unsigned char Pkey[8],ChildKey[16][48];
		//unsigned char temp[16][6];
		unsigned char temp_a;
		//unsigned char *res;
		unsigned long i,j,k,m,row,h,time,ReturnLen,SrcLen,KeyLen;
		i=0;
		//get strlen
		KeyLen=0;
		SrcLen=0;

		unsigned char *pkey,*pSour;
		pkey=key;
		pSour=sour;

		while(*pkey)
		{
			++KeyLen;
			pkey++;
		}
		while(*pSour)
		{
			++SrcLen;
			pSour++;
		}

		if(SrcLen%8)
			i=1;
		i=(SrcLen/8+i);
		ReturnLen=i*8;
		//res=dest;
		for(i=0;i<8;i++)	Pkey[i]=key[i];
		if(KeyLen<8)
			for(i=0;(short)i<(8-KeyLen);i++)
				Pkey[KeyLen+(short)i]=0x00;
			Gen_Childkey1(Pkey,ChildKey);
			//group
			if((SrcLen%8)==0)
			{
				time=SrcLen/8;
				for(i=0;i<time;i++)
					for(j=0;j<8;j++)	src[i][j]=sour[i*8+j];
			}
			else
			{
				time=SrcLen/8+1;
				for(i=0;i<time;i++)
					for(j=0;j<8;j++)
						if((i*8+j)<SrcLen)	src[i][j]=sour[i*8+j];
						else			src[i][j]=0x00;
			}
			//des
			for(m=0;m<time;m++)
			{
				Char_Bit(src[m],8,src_bit);
				for(i=0;i<64;i++)	ipt[i]=src_bit[ip[i]-1];	//ip
				for(i=0;i<32;i++)
				{						//r0,l0
					l[i]=ipt[i];
					r[i]=ipt[i+32];
				}
				for(k=0;k<16;k++)
				{
					pt=pt1;
					for(i=0;i<48;i++)	et[i]=r[e[i]-1];    	//e
					for(i=0;i<48;i++)	et[i]=et[i]^ChildKey[k][i];
					//xor
					for(i=0;i<8;i++)
					{
						row=et[i*6+0]*2+et[i*6+5];		//s[i]
						h=et[i*6+1]*8+et[i*6+2]*4+et[i*6+3]*2+et[i*6+4];
						temp_a=si[i][row*16+h];
						if(temp_a&0x08)	*pt++=0x01;
						else		*pt++=0x00;
						if(temp_a&0x04)	*pt++=0x01;
						else		*pt++=0x00;
						if(temp_a&0x02)	*pt++=0x01;
						else		*pt++=0x00;
						if(temp_a&0x01)	*pt++=0x01;
						else		*pt++=0x00;
					}
					for(i=0;i<32;i++)	pt2[i]=pt1[p[i]-1];
					for(i=0;i<32;i++)	pt2[i]=pt2[i]^l[i];	//r1
					for(i=0;i<32;i++)	{l[i]=r[i];	r[i]=pt2[i];}
				}
				for(i=0;i<32;i++)   	{ipt[i+32]=l[i];	ipt[i]=r[i];}
				for(i=0;i<64;i++)	src_bit[i]=ipt[fp[i]-1];
				Bit_Char(src_bit,64,dest);
				dest+=8;
			}
			return (0);
		}
		else if(m==1)
		{
			__int16 ip[]=
			{
				58,50,42,34,26,18,10,2,
					60,52,44,36,28,20,12,4,
					62,54,46,38,30,22,14,6,
					64,56,48,40,32,24,16,8,
					57,49,41,33,25,17,9 ,1,
					59,51,43,35,27,19,11,3,
					61,53,45,37,29,21,13,5,
					63,55,47,39,31,23,15,7
			};
			unsigned char fp[] =  	
			{
				40,8,48,16,56,24,64,32,
					39,7,47,15,55,23,63,31,
					38,6,46,14,54,22,62,30,
					37,5,45,13,53,21,61,29,
					36,4,44,12,52,20,60,28,
					35,3,43,11,51,19,59,27,
					34,2,42,10,50,18,58,26,
					33,1,41, 9,49,17,57,25
			};
			__int16 e[]=	
			{
				32,1 ,2 ,3 ,4 ,5 ,
					4 ,5 ,6 ,7 ,8 ,9 ,
					8, 9 ,10,11,12,13,
					12,13,14,15,16,17,
					16,17,18,19,20,21,
					20,21,22,23,24,25,
					24,25,26,27,28,29,
					28,29,30,31,32,1
			};
			__int16 p[]=	
			{
				16,7 ,20,21,
					29,12,28,17,
					1 ,15,23,26,
					5 ,18,31,10,
					2 ,8 ,24,14,
					32,27,3 ,9,
					19,13,30,6,
					22,11,4 ,25
			};
			unsigned char si[8][64] =
			{
				{14,4 ,13,1 ,2 ,15,11,8 ,3 ,10,6 ,12,5 ,9 ,0 ,7 ,
					0 ,15,7 ,4 ,14,2 ,13,1 ,10,6 ,12,11,9 ,5 ,3 ,8 ,
					4 ,1 ,14,8 ,13,6 ,2 ,11,15,12,9 ,7 ,3 ,10,5 ,0 ,
					15,12,8 ,2 ,4 ,9 ,1 ,7 ,5 ,11,3 ,14,10,0 ,6 ,13},
					
				{15,1 ,8 ,14,6 ,11,3 ,4 ,9 ,7 ,2 ,13,12,0 ,5 ,10,
				3, 13,4 ,7 ,15,2 ,8 ,14,12,0 ,1 ,10,6 ,9 ,11,5 ,
				0, 14,7 ,11,10,4 ,13,1 ,5 ,8 ,12,6 ,9 ,3 ,2 ,15,
				13,8 ,10,1 ,3 ,15,4 ,2 ,11,6 ,7 ,12,0 ,5 ,14,9 },
				
				{10,0 ,9 ,14,6 ,3 ,15,5 ,1 ,13,12,7 ,11,4 ,2 ,8 ,
				13,7 ,0 ,9 ,3 ,4 ,6 ,10,2 ,8 ,5 ,14,12,11,15,1 ,
				13,6 ,4 ,9 ,8 ,15,3 ,0 ,11,1 ,2 ,12,5 ,10,14,7 ,
				1 ,10,13,0 ,6 ,9 ,8 ,7 ,4 ,15,14,3 ,11,5 ,2 ,12},
				
				{7 ,13,14,3 ,0 ,6 ,9 ,10,1 ,2 ,8 ,5 ,11,12,4 ,15,
				13,8 ,11,5 ,6 ,15,0 ,3 ,4 ,7 ,2 ,12,1 ,10,14,9 ,
				10,6 ,9 ,0 ,12,11,7 ,13,15,1 ,3 ,14,5 ,2 ,8 ,4 ,
				3 ,15,0 ,6 ,10,1 ,13,8 ,9 ,4 ,5 ,11,12,7 ,2 ,14},
				
				{2 ,12,4 ,1 ,7 ,10,11,6 ,8 ,5 ,3 ,15,13,0 ,14,9 ,
				14,11,2 ,12,4 ,7 ,13,1 ,5 ,0 ,15,10,3 ,9 ,8 ,6,
				4 ,2 ,1 ,11,10,13,7 ,8 ,15,9 ,12,5 ,6 ,3 ,0 ,14,
				11,8 ,12,7 ,1 ,14,2 ,13,6 ,15,0 ,9 ,10,4 ,5 ,3 },
				
				{12,1 ,10,15,9 ,2 ,6 ,8 ,0 ,13,3 ,4 ,14,7 ,5 ,11,
				10,15,4 ,2 ,7 ,12,9 ,5 ,6 ,1 ,13,14,0 ,11,3 ,8 ,
				9 ,14,15,5 ,2 ,8 ,12,3 ,7 ,0 ,4 ,10,1 ,13,11,6 ,
				4 ,3 ,2 ,12,9 ,5 ,15,10,11,14,1 ,7 ,6 ,0 ,8 ,13},
				
				{4 ,11,2 ,14,15,0 ,8 ,13,3 ,12,9 ,7 ,5 ,10,6 ,1 ,
				13,0 ,11,7 ,4 ,9 ,1 ,10,14,3 ,5 ,12,2 ,15,8 ,6 ,
				1 ,4 ,11,13,12,3 ,7 ,14,10,15,6 ,8 ,0 ,5 ,9 ,2 ,
				6 ,11,13,8 ,1 ,4 ,10,7 ,9 ,5 ,0 ,15,14,2 ,3 ,12},
				
				{13,2 ,8 ,4 ,6 ,15,11,1 ,10,9 ,3 ,14,5 ,0 ,12,7 ,
				1 ,15,13,8 ,10,3 ,7 ,4 ,12,5 ,6 ,11,0 ,14,9 ,2 ,
				7 ,11,4 ,1 ,9 ,12,14,2 ,0 ,6 ,10,13,15,3 ,5 ,8 ,
				2 ,1 ,14,7 ,4 ,10,8 ,13,15,12,9 ,0 ,3 ,5 ,6 ,11}
			};
			
			unsigned char src[1000][8],src_bit[64],ipt[64];
			unsigned char et[48],pt1[32],pt2[32],r[32],l[32],*pt;
			unsigned char Pkey[8],ChildKey[16][48];
			//unsigned char temp[16][6];
			unsigned char temp_a;
			//unsigned char *res;
			unsigned long i,j,k,m,row,h,time,ReturnLen,KeyLen,SrcLen;
			
			i=0;
			//get strlen
			KeyLen=0;
			SrcLen=0;
			
			unsigned char *pkey,*pSour;
			pkey=key;
			pSour=sour;
			
			while(*pkey)
			{
				++KeyLen;
				pkey++;
			}
			while(*pSour)
			{
				++SrcLen;
				pSour++;
			}

			if(SrcLen%8)
				i=1;
			i=SrcLen/8+i;
			ReturnLen=i*8;
			//res=dest;
			for(i=0;i<8;i++)	Pkey[i]=key[i];
			if(KeyLen<8)
				for(i=0;(short)i<8-KeyLen;i++)	
					Pkey[KeyLen+(short)i]=0x00;
				Gen_Childkey1(Pkey,ChildKey);
				//group
				if((SrcLen%8)==0)
				{
					time=SrcLen/8;
					for(i=0;i<time;i++)
						for(j=0;j<8;j++)	src[i][j]=sour[i*8+j];
				}
				else
				{
					time=SrcLen/8+1;
					for(i=0;i<time;i++)
						for(j=0;j<8;j++)
							if((i*8+j)<SrcLen)	src[i][j]=sour[i*8+j];
							else		src[i][j]=0x00;
				}
				//des
				for(m=0;m<time;m++)
				{
					Char_Bit(src[m],8,src_bit);
					for(i=0;i<64;i++)	ipt[i]=src_bit[ip[i]-1];	//ip
					for(i=0;i<32;i++)
					{						//r0,l0
						l[i]=ipt[i];
						r[i]=ipt[i+32];
					}
					for(k=0;k<16;k++)
					{
						pt=pt1;
						for(i=0;i<48;i++)	et[i]=r[e[i]-1];    	//e
						for(i=0;i<48;i++)	et[i]=et[i]^ChildKey[15-k][i];
						//xor
						for(i=0;i<8;i++)
						{
							row=et[i*6+0]*2+et[i*6+5];		//s[i]
							h=et[i*6+1]*8+et[i*6+2]*4+et[i*6+3]*2+et[i*6+4];
							temp_a=si[i][row*16+h];
							if(temp_a&0x08)	*pt++=0x01;
							else		*pt++=0x00;
							if(temp_a&0x04)	*pt++=0x01;
							else		*pt++=0x00;
							if(temp_a&0x02)	*pt++=0x01;
							else		*pt++=0x00;
							if(temp_a&0x01)	*pt++=0x01;
							else		*pt++=0x00;
						}
						for(i=0;i<32;i++)	pt2[i]=pt1[p[i]-1];
						for(i=0;i<32;i++)	pt2[i]=pt2[i]^l[i];	//r1
						for(i=0;i<32;i++)	{l[i]=r[i];	r[i]=pt2[i];}
					}
					for(i=0;i<32;i++)   	{ipt[i+32]=l[i];	ipt[i]=r[i];}
					for(i=0;i<64;i++)	src_bit[i]=ipt[fp[i]-1];
					Bit_Char(src_bit,64,dest);
					dest+=8;
				}
				return (0);
			
		}
		else 
			return 1;
}

//13
DLLSPEC int _stdcall fw_changeb3(int icdev,unsigned char _SecNr,
				unsigned char *_KeyA,unsigned char *_CtrlW,unsigned char _Bk,
				unsigned char *_KeyB)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;
		temp[0]=0x00;
		temp[1]=0x2;
		temp[2]=0x2;
		temp[3]=0x47;
		temp[4]=0x11;
		
		temp[5]=_SecNr;
		for(int i=0;i<6;i++)
		{
			temp[6+i]=*(_KeyA++);
			temp[16+i]=*(_KeyB++);
		}

		for(int j=12;j<16;j++)
		{
			temp[j]=*(_CtrlW++);
		}

		temp[22]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6]^temp[7]^temp[8]^temp[9]^\
			temp[10]^temp[11]^temp[12]^temp[13]^temp[14]^temp[15]^temp[16]^\
			temp[17]^temp[18]^temp[19]^temp[20]^temp[21];
		
		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed
		
		return 0;//return success
	}	
	else
		return (0x20);//open endpoint error
}
//14
DLLSPEC __int16 __stdcall fw_authentication_passaddr(HANDLE icdev,unsigned char _Mode, 
											 unsigned char blockAddr,
											 unsigned char *passbuff)
{
	return 0;
}
//15
DLLSPEC int _stdcall fw_initval(int icdev,unsigned char _Adr,unsigned long _Value)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;
		
		temp[1]=0x02;
		temp[2]=0x02;
		temp[3]=0x47;
		temp[4]=0x11;
		temp[5]=_Adr;

		//convert long to H
		char pVal[16];
		itoa(_Value,pVal,16);
		int len=strlen(pVal);
		char tempbuf[8];
		memset(tempbuf,'0',8);

		for(int s=0;s<len;s++)
		{
			tempbuf[7-s]=pVal[len-s-1];
		}
		
		for(int m=0;m<4;m++)
		{
			char conBuffer[2];
			conBuffer[0]=tempbuf[m*2];
			conBuffer[1]=tempbuf[m*2+1];
			temp[9-m]=(unsigned char)strtol(conBuffer,NULL,16);

			temp[17-m]=temp[9-m];
		}


		char notTemp[16];
		itoa(~_Value,notTemp,16);
		int k=0;
		for(int n=13;n>9;n--)
		{
			
			char strtemp[2];
			for(int j=0;j<2;j++)
			{
				strtemp[j]=notTemp[k];
				k++;
			}
			temp[n]=(unsigned char)strtol(strtemp,NULL,16);
		}
		temp[18]=_Adr;
		temp[19]=~_Adr;
		temp[20]=_Adr;
		temp[21]=~_Adr;
		temp[22]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6]^temp[7]^temp[8]^temp[9]^\
			temp[10]^temp[11]^temp[12]^temp[13]^temp[14]^temp[15]^temp[16]^\
			temp[17]^temp[18]^temp[19]^temp[20]^temp[21];


		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return OutReport[3];//call failed

		return 0;//success
	}
	else 
		return (0x20);//open endpoint error
}
//16
DLLSPEC int _stdcall fw_increment(int icdev,unsigned char _Adr,unsigned long _Value)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;
		temp[0]=0x00;
		temp[1]=0x2;
		temp[2]=0x2;
		temp[3]=0x48;
		temp[4]=0x05;

		temp[5]=_Adr;

		//convert long to H
		char str[16];
		
		itoa(_Value,str,16);
		int len=strlen(str);
		
		
		char tempbuf[8];
		memset(tempbuf,'0',8);
		for(int k=0;k<len;k++)
		{
			tempbuf[7-k]=str[len-k-1];
		}
		
		for(int m=0;m<4;m++)
		{
			char conBuffer[2];
			conBuffer[0]=tempbuf[m*2];
			conBuffer[1]=tempbuf[m*2+1];
			temp[9-m]=(unsigned char)strtol(conBuffer,NULL,16);
		}
		

		temp[10]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6]^temp[7]^temp[8]^temp[9];


		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed

		return 0;//return success
	}	
	else
		return (0x20);//open endpoint error
}
//17
DLLSPEC int _stdcall fw_readval(int icdev,unsigned char _Adr,unsigned long *_Value)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];

		memset(temp,0,255);
		OutReport[0]=0;
		temp[0]=0x00;
		temp[1]=0x02;
		temp[2]=0x02;
		temp[3]=0x46;
		temp[4]=0x01;
		temp[5]=_Adr;
		temp[6]=temp[2]^temp[3]^temp[4]^temp[5];

		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed


		char *str,*pstr;
		str=( char*)malloc(64);
		pstr=str;
		for(int k=8;k>4;k--)
		{
			BYTE bt=*(char*)(OutReport+k);//ַ 
			int i=(int)bt;
			if(i!=0)
			{
				itoa(i,str,16);
				if(strlen(str)==1)
				{
					char chtemp=*str;
					*str='0';
					*(str+1)=chtemp;
				}
			}
			else
			{
				*str='0';
				*(str+1)='0';
			}

			str+=2;
		}
		
		*_Value=strtol(pstr,NULL,16);//get the value		

	
		return (0);//return sucess
	}
	else
		return (0x20);//open endpoint error
}
//18
DLLSPEC int _stdcall fw_decrement(int icdev,unsigned char _Adr,unsigned long _Value)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
	
		memset(temp,0,255);
		OutReport[0]=0;
		temp[0]=0x00;
		temp[1]=0x02;
		temp[2]=0x02;
		temp[3]=0x49;
		temp[4]=0x05;

		temp[5]=_Adr;

		//convert long to H
		char str[16];
		
		itoa(_Value,str,16);
		int len=strlen(str);
		
		
		char tempbuf[8];
		memset(tempbuf,'0',8);
		for(int k=0;k<len;k++)
		{
			tempbuf[7-k]=str[len-k-1];
		}
		
		for(int m=0;m<4;m++)
		{
			char conBuffer[2];
			conBuffer[0]=tempbuf[m*2];
			conBuffer[1]=tempbuf[m*2+1];
			temp[9-m]=(unsigned char)strtol(conBuffer,NULL,16);
		}

		temp[10]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6]^temp[7]^temp[8]^temp[9];

		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);

		if(OutReport[3])
			return (OutReport[3]);//call failed

		return 0;//return sucess
	}
	else
		return (0x20);//open endpoint error
}
//19
DLLSPEC int _stdcall fw_HL_authentication(int icdev,unsigned char reqmode,
										  unsigned long snr,unsigned char authmode,
										  unsigned char secnr)
{
	return 0;
}
//20
DLLSPEC int _stdcall fw_HL_read(int icdev,unsigned char _Mode,unsigned char _Adr,
			   unsigned long _Snr,unsigned char *_Data, unsigned long *_NSnr)
{
	return 0;
}
//21
DLLSPEC int _stdcall fw_HL_write(int icdev,unsigned char _Mode,unsigned char _Adr,
				unsigned long *_Snr,unsigned char *_Data)
{
	return 0;
}
//22
DLLSPEC int _stdcall fw_restore(int icdev,unsigned char _Adr)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;

		temp[1]=0x02;
		temp[2]=0x02;
		temp[3]=0x4a;
		temp[4]=0x01;
		//data
		temp[5]=_Adr;
		temp[6]=temp[2]^temp[3]^temp[4]^temp[5];
		
		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed

		return 0;//sucess
	}
	else
		return (0x20);//opne endpoint failed
}
//23
DLLSPEC int _stdcall fw_transfer(int icdev,unsigned char _Adr)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;

		temp[0]=0x00;
		temp[1]=0x02;
		temp[2]=0x02;
		temp[3]=0x4b;
		temp[4]=0x01;
		//data
		temp[5]=_Adr;

		temp[6]=temp[2]^temp[3]^temp[4]^temp[5];

		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed

		return 0;//success
	}
	else
		return (0x20);//open endpoint failed
}
//24
DLLSPEC int _stdcall fw_authentication_2(int icdev,unsigned char _Mode,unsigned char KeyNr,
						unsigned char Adr)
{
	return 0;
}
//25
DLLSPEC int _stdcall fw_authentication_pass(int icdev, unsigned char _Mode, 
											unsigned char Addr,
						   unsigned char *passbuff)
{
	return 0;
}
//26
DLLSPEC int _stdcall fw_card_double(int icdev,unsigned char _Mode,unsigned char *_Snr)
{
	return 0;
}

/*----------device Functions(down)--------*/
//1
DLLSPEC int _stdcall fw_beep(int icdev,unsigned int _Msec)
{
	HANDLE hDev=(HANDLE)icdev;
	unsigned char temp[255];
	memset(temp,0,255);
	temp[0]=0x00;
	temp[1]=0x2;
	temp[2]=0x2;
	temp[3]=0x57;
	temp[4]=0x2;
	temp[5]=0xa;
	temp[6]=0x00;
	temp[7]=0x5d;
	temp[8]=0x00;
	
	BOOL flag=FALSE;
	flag=HidD_SetFeature(hDev,temp,0x21);
	int ErrorType;
	ErrorType=GetLastError();
	if(ErrorType!=0)
		return ErrorType;
	return 0;
}
//2
DLLSPEC int _stdcall fw_disp_mode(int icdev,unsigned char mode)
{

    return 0;
}
//3
DLLSPEC int _stdcall fw_disp_str(int icdev,char *digit)
{
	return 0;
}
//4
DLLSPEC int _stdcall fw_gettime(int icdev,unsigned char *time)
{
	return 0;
}
//5
DLLSPEC int _stdcall fw_getver(int icdev,unsigned char *buff)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;
		temp[1]=0x02;
		temp[2]=0x02;
		temp[3]=0x80;
		temp[4]=0x00;
		temp[5]=temp[2]^temp[3]^temp[4];

		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed
		*buff=OutReport[5];
		*(buff+1)=OutReport[6];

		return 0;//sucess
	}
	else
		return (0x20);//open endpoint failed
}
//6
DLLSPEC int _stdcall fw_high_disp(int icdev,unsigned char offset,
								  unsigned char disp_len,unsigned char *disp_str)
{
	return 0;
}
//7
DLLSPEC int _stdcall fw_setbright(int icdev,unsigned char bright)
{
	return 0;
}
//8
DLLSPEC int _stdcall fw_settime(int icdev,unsigned char *time)
{
	return 0;
}
//9
DLLSPEC int _stdcall fw_srd_eeprom(int icdev,int offset,int length,
								   unsigned char *rec_buffer)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;
		temp[1]=0x02;
		temp[2]=0x02;
		temp[3]=0x37;
		temp[4]=0x03;
		//data
		//convert long to H
		char str[16];
		
		itoa((offset+400),str,16);
		int len=strlen(str);
		
		
		char tempbuf[4];
		memset(tempbuf,'0',4);
		for(int k=0;k<len;k++)
		{
			tempbuf[3-k]=str[len-k-1];
		}
		
		for(int m=0;m<1;m++)
		{
			char conBuffer[2];
			conBuffer[0]=tempbuf[m*2];
			conBuffer[1]=tempbuf[m*2+1];
			temp[6-m]=(unsigned char)strtol(conBuffer,NULL,16);
		}
		 


		temp[7]=(unsigned char)length;
		temp[8]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6]^temp[7];

		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed
		for(int l=0;l<length;l++)
		{
			*(rec_buffer++)=OutReport[5+l];
		}

		return 0;//sucess
	}
	else
		return (0x20);//opne endpoint failed
}
//10
DLLSPEC int _stdcall fw_swr_eeprom(int icdev,int offset,int length,
								   unsigned char* buffer)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		unsigned char *pbuffer;
		pbuffer=buffer;
		memset(temp,0,255);
		OutReport[0]=0;
		if(length<1)
		{
			return (0x7c);//varify error
		}
		else if(length<25)
		{
			temp[1]=0x02;
			temp[2]=0x02;
			temp[3]=0x38;
			temp[4]=(unsigned char)(length+3);

			int valLen=0;
			int skipLen=0;
			int realLen=0;
			//get valLen
			char constch[16]={'c','c'};
			char te[4];
			itoa((int)*pbuffer,te,16);


			while(strcmp((char *)constch,te))
			{
				++valLen;
				pbuffer++;
				itoa((int)*pbuffer,te,16);
			}
			//get skipLen

			while(!strcmp((char *)constch,te))
			{
				++skipLen;
				pbuffer++;
				itoa((int)*pbuffer,te,16);
			}
			//get realLen
			realLen=valLen+skipLen;


			if(length<=valLen)
			{
			
				//data
				char str[16];
				
				itoa((offset+400),str,16);
				int len=strlen(str);
				
				char tempbuf[4];
				memset(tempbuf,'0',4);
				for(int k=0;k<len;k++)
				{
					tempbuf[3-k]=str[len-k-1];
				}
				
				for(int m=0;m<2;m++)
				{
					char conBuffer[2];
					conBuffer[0]=tempbuf[m*2];
					conBuffer[1]=tempbuf[m*2+1];
					temp[6-m]=(unsigned char)strtol(conBuffer,NULL,16);
				}

				temp[7]=(unsigned char)length;

				for(int n=8;n<length+8;n++)
				{
					temp[n]=*(buffer++);
				}
				unsigned char xorChar=0x00;
				for(int l=0;l<length+6;l++)
				{
					xorChar^=temp[2+l];
				}
				temp[n]=xorChar;

				HidD_SetFeature(hDev,temp,0x21);
				HidD_GetFeature(hDev,OutReport,0x21);
				if(OutReport[3])
					return (OutReport[3]);//call failed
				return (0);

			}
			else
			{
				//data
				char str[16];
				
				itoa((offset+400),str,16);
				int len=strlen(str);
				
				char tempbuf[4];
				memset(tempbuf,'0',4);
				for(int k=0;k<len;k++)
				{
					tempbuf[3-k]=str[len-k-1];
				}
				
				for(int m=0;m<2;m++)
				{
					char conBuffer[2];
					conBuffer[0]=tempbuf[m*2];
					conBuffer[1]=tempbuf[m*2+1];
					temp[6-m]=(unsigned char)strtol(conBuffer,NULL,16);
				}

				temp[7]=(unsigned char)length;

				for(int n=8;n<valLen+8;n++)
				{
					temp[n]=*(buffer++);
				}

				for(int y=n;y<n+length-valLen-1;y++)
				{
					temp[y]=0xcc;
				}

				n=n+(length-valLen-1);

				

				if((length-realLen)<=7)
				{
					switch(length-realLen)
					{
					case 1:
						{
							temp[n]=0xcc;
							unsigned char xorChar=0x00;
							for(int t=0;t<length+6;t++)
							{
								xorChar^=temp[2+t];
							}
							temp[n+1]=xorChar;
							break;
						}
					case 2:
						{
							temp[n]=0xcc;
							temp[n+1]=0xcc;

							unsigned char xorChar=0x00;
							for(int t=0;t<length+6;t++)
							{
								xorChar^=temp[2+t];
							}
							temp[n+2]=xorChar;
							break;
						}
					case 3:
						{
							temp[n]=0xcc;
							temp[n+1]=0xcc;
							temp[n+2]=0xcc;

							unsigned char xorChar=0x00;
							for(int t=0;t<length+6;t++)
							{
								xorChar^=temp[2+t];
							}
							temp[n+3]=xorChar;
							break;
						}
					case 4:
						{
							temp[n]=0xcc;
							temp[n+1]=0xcc;
							temp[n+2]=0xcc;
							temp[n+3]=0xd0;

							unsigned char xorChar=0x00;
							for(int t=0;t<length+6;t++)
							{
								xorChar^=temp[2+t];
							}
							temp[n+4]=xorChar;
							break;
						}
					case 5:
						{
							temp[n]=0xcc;
							temp[n+1]=0xcc;
							temp[n+2]=0xcc;
							temp[n+3]=0xd0;
							temp[n+4]=0xa0;


							unsigned char xorChar=0x00;
							for(int t=0;t<length+6;t++)
							{
								xorChar^=temp[2+t];
							}
							temp[n+5]=xorChar;
							break;
						}
					case 6:
						{
							temp[n]=0xcc;
							temp[n+1]=0xcc;
							temp[n+2]=0xcc;
							temp[n+3]=0xd0;
							temp[n+4]=0xa0;
							temp[n+5]=0x52;

							unsigned char xorChar=0x00;
							for(int t=0;t<length+6;t++)
							{
								xorChar^=temp[2+t];
							}
							temp[n+6]=xorChar;
							break;
						}
					case 7:
						{
							temp[n]=0xcc;
							temp[n+1]=0xcc;
							temp[n+2]=0xcc;
							temp[n+3]=0xd0;
							temp[n+4]=0xa0;
							temp[n+5]=0x52;
							temp[n+6]=0x00;

							unsigned char xorChar=0x00;
							for(int t=0;t<length+6;t++)
							{
								xorChar^=temp[2+t];
							}
							temp[n+7]=xorChar;
							break;
						}

					default:
						break;
					}
				}
				else
				{
					temp[n]=0xcc;
					temp[n+1]=0xcc;
					temp[n+2]=0xcc;
					temp[n+3]=0xd0;
					temp[n+4]=0xa0;
					temp[n+5]=0x52;
					temp[n+6]=0x00;

					unsigned char xorChar=0x00;
					for(int t=0;t<length+6;t++)
					{
						xorChar^=temp[2+t];
					}
					temp[n+7]=xorChar;

				}

				

				HidD_SetFeature(hDev,temp,0x21);
				HidD_GetFeature(hDev,OutReport,0x21);
				if(OutReport[3])
					return (OutReport[3]);//call failed
				return (0);
			}
		}//else if(length<25)
		else
		{
			return 0;

		}


		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed


		return 0;//sucess
	}
	else
		return (0x20);//opne endpoint failed
}
//11 convert hex to commond char 
//len:the length of commond buffer
DLLSPEC __int16 _stdcall a_hex(unsigned char *a,unsigned char *hex,__int16 len)
{
	int k=0;
	int i;

	unsigned char sch[1024];
	memset(sch,0,1024);

//	if(len%2!=0)
//	{
//		return 1;
//	}
	for(int l=0;l<2*len;l++)
	{
		sch[l]=*(hex++);
	}

//	switch(/*dstrlen*/len/2)
	{
//	case 4:
		unsigned char dBuffer[1024];
		
		for(i=0;i</*dstrlen*/len;i++)
		{
			char tempBuffer[2];
			for(int j=0;j<2;j++)
			{
				tempBuffer[j]=sch[k];
				k++;
			}
			long testl;
			testl=strtol(tempBuffer,NULL,16);
			if(0==testl)
			{
				if(!(('0'==tempBuffer[0])&&('0'==tempBuffer[1])))
					return 1;
			}
			
			dBuffer[i]=(unsigned char)strtol(tempBuffer,NULL,16);
			*(a++)=dBuffer[i];
		}
	}

	return 0;
}
//12  convert commond char to Hex
//len:the length of hex buffer
DLLSPEC void _stdcall hex_a(unsigned char *hex,unsigned char *a,__int16 len)
{
	unsigned char temp[1024];

	memset(temp,0,1024);
	int index=0;

	for(int i=0;i<len/2;i++)
	{
		//convert commond char to Hex


		char srvbuffer[2];
		itoa((int)(*a++),srvbuffer,16);

		int templen=strlen(srvbuffer);//len=1
		
		char tempbuf[2];
		memset(tempbuf,'0',2);

		for(int k=0;k<templen;k++)
		{
			tempbuf[1-k]=srvbuffer[templen-k-1];//tempbuf=0x03,0xe8
		}
		
		for(int m=0;m<2;m++)
		{
			unsigned char te;
			te=tempbuf[m];
			temp[index]=te;
			index++;
			*(hex++)=te;//'0','3','e','8'...
		}
	}


//	int Destrlen=strlen((char *)temp);
//	for(int x=0;x<Destrlen;x++)
//	{
//		*(a++)=temp[x];
//	}


	return ;
}
//13
DLLSPEC __int16 __stdcall fw_reset(HANDLE icdev,unsigned __int16 _Msec)
{
	if(icdev)
	{
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;
		temp[1]=0x02;
		temp[2]=0x02;
		temp[3]=0x4e;
		temp[4]=0x02;
		//data
		//convert long to H
		char str[16];
		
		itoa(_Msec,str,16);
		int len=strlen(str);
		
		
		char tempbuf[4];
		memset(tempbuf,'0',4);
		for(int k=0;k<len;k++)
		{
			tempbuf[3-k]=str[len-k-1];
		}
		
		for(int m=0;m<2;m++)
		{
			char conBuffer[2];
			conBuffer[0]=tempbuf[m*2];
			conBuffer[1]=tempbuf[m*2+1];
			temp[6-m]=(unsigned char)strtol(conBuffer,NULL,16);
		}
		temp[7]=temp[2]^temp[3]^temp[4]^temp[5]^temp[6];

		HidD_SetFeature(icdev,temp,0x21);
		HidD_GetFeature(icdev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed

		return 0;//sucess
	}
	else
		return (0x20);//opne endpoint failed
}

/*----------device Functions(down)----------*/

//-----------------------------------------------
//-------------4442 Commond Functions(down)
//-----------------------------------------------
//1
DLLSPEC int _stdcall fw_read_4442(int icdev,unsigned char _Adr,unsigned char *_Data,
								  int length)
{
	if(icdev)
	{
		

		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;

		temp[1]=CARD4442SENTTITLE1;
		temp[2]=CARD4442SENTTITLE2;
		temp[3]=0x70;
		temp[4]=0x03;
		//data
		temp[5]=0x71;
		temp[6]=_Adr;
		temp[7]=length;//lenght must not bigger than 24
		
		//get and set xor buffer
		unsigned char xorbuffer=0;
		for(int i=2;i<8;i++)
		{
			xorbuffer^=temp[i];
		}
		temp[8]=xorbuffer;

		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed
		//get read result
		int realLen=(int)OutReport[4];

		if(realLen<27)
		{
			for(int j=0;j<realLen;j++)
			{
				*(_Data++)=OutReport[5+j];
			}
		}
		else//clip serveral times to receive
		{
			
			int getTime=0;
			int iData=0;//the current count of out feature data
			getTime=realLen/30+1;
			//the first time
			for(int l=0;l<27;l++)
			{
				*(_Data++)=OutReport[5+l];
				++iData;
			}
			getTime--;
			
			//loop to get Feature data
			while(getTime>=1)
			{
				if(getTime!=1)
				{
					temp[6]=(unsigned char)((int)_Adr+iData);
					temp[7]=32;

					//get and set xor buffer
					unsigned char xorbuffer=0;
					for(int i=2;i<8;i++)
					{
						xorbuffer^=temp[i];
					}
					temp[8]=xorbuffer;

					HidD_SetFeature(hDev,temp,0x21);
					HidD_GetFeature(hDev,OutReport,0x21);
					if(OutReport[3])
						return (OutReport[3]);//call failed
					for(int j=0;j<32;j++)
					{
						*(_Data++)=OutReport[5+j];
						++iData;
					}
					getTime--;
				}
				else//the last time to get feature data
				{
					int ltimelen=realLen-iData;


					temp[6]=(unsigned char)((int)_Adr+iData);
					temp[7]=ltimelen;

					//get and set xor buffer
					unsigned char xorbuffer=0;
					for(int i=2;i<8;i++)
					{
						xorbuffer^=temp[i];
					}
					temp[8]=xorbuffer;

					HidD_SetFeature(hDev,temp,0x21);
					HidD_GetFeature(hDev,OutReport,0x21);
					if(OutReport[3])
						return (OutReport[3]);//call failed

					for(int j=0;j<ltimelen;j++)
					{
						*(_Data++)=OutReport[5+j];
					}
					getTime--;

				}

			}



		}

		return(0);//sucess
	}
	else
		return(0x20);//open endpoint failed
}
//2
DLLSPEC int _stdcall fw_write_4442(int icdev,unsigned char _Adr,unsigned char *_Data,
								   int length)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;

		temp[1]=CARD4442SENTTITLE1;
		temp[2]=CARD4442SENTTITLE2;
		temp[3]=0x70;
		temp[4]=(unsigned char)(length+3);
		//data
		temp[5]=0x72;
		temp[6]=_Adr;
		temp[7]=length;//lenght must not bigger than 24

		for(int j=0;j<length;j++)
		{
			temp[8+j]=*(_Data++);
		}
		
		//get and set xor buffer
		unsigned char xorbuffer=0;
		for(int i=2;i<8+length;i++)
		{
			xorbuffer^=temp[i];
		}
		temp[8+j]=xorbuffer;

		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed

		return(0);//sucess
	}
	else
		return(0x20);//open endpoint failed
}
//3
DLLSPEC int _stdcall fw_getProtectData_4442(int icdev,unsigned char _Adr,
											unsigned char *_Data,int length)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;

		temp[1]=CARD4442SENTTITLE1;
		temp[2]=CARD4442SENTTITLE2;
		temp[3]=0x70;
		temp[4]=0x03;
		//data
		temp[5]=0x73;
		temp[6]=_Adr;
		temp[7]=length;//lenght must not bigger than 24
		
		//get and set xor buffer
		unsigned char xorbuffer=0;
		for(int i=2;i<8;i++)
		{
			xorbuffer^=temp[i];
		}
		temp[8]=xorbuffer;

		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed
		//get read result
		int realLen=(int)OutReport[4];
		for(int j=0;j<realLen;j++)
		{
			*(_Data++)=OutReport[5+j];
		}

		return(0);//sucess
	}
	else
		return(0x20);//open endpoint failed
}
//4
DLLSPEC int _stdcall fw_setProtectData_4442(int icdev,unsigned char _Adr,
											unsigned char *_Data,int length)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;

		temp[1]=CARD4442SENTTITLE1;
		temp[2]=CARD4442SENTTITLE2;
		temp[3]=0x70;
		temp[4]=(unsigned char)(length+3);
		//data
		temp[5]=0x74;
		temp[6]=_Adr;
		temp[7]=length;//lenght must not bigger than 24

		for(int j=0;j<length;j++)
		{
			temp[8+j]=*(_Data++);
		}
		
		//get and set xor buffer
		unsigned char xorbuffer=0;
		for(int i=2;i<6+length;i++)
		{
			xorbuffer^=temp[i];
		}
		temp[8+j]=xorbuffer;

		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed

		return(0);//sucess
	}
	else
		return(0x20);//open endpoint failed
}
//5
DLLSPEC int _stdcall fw_authentikey_4442(int icdev,unsigned char _Adr,int rlen,
										 unsigned char *key)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;

		temp[1]=CARD4442SENTTITLE1;
		temp[2]=CARD4442SENTTITLE2;
		temp[3]=0x70;
		temp[4]=0x06;
		//data
		temp[5]=0x75;
		temp[6]=0x00;
	//	temp[7]=(unsigned char)rlen;//rlen=3
		temp[7]=0x03;

		for(int j=0;j<3;j++)
		{
			temp[8+j]=*(key++);
		}
		
		//get and set xor buffer
		unsigned char xorbuffer=0;
		for(int i=2;i<11;i++)
		{
			xorbuffer^=temp[i];
		}
		temp[11]=xorbuffer;

		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed

		unsigned char checkbuffer[2];//use for check
		memset(checkbuffer,0,2);
		if(fw_read_4442(icdev,0xff,checkbuffer,1))
		{
			return (1);
		}

		if(fw_write_4442(icdev,0xff,checkbuffer,1))
		{
			return(1);
		}
		unsigned char cmpbuffer[2];
		memset(cmpbuffer,0,2);
		if(fw_read_4442(icdev,0xff,cmpbuffer,1))
		{
			return(1);
		}
		if(strcmp((char*)cmpbuffer,(char*)checkbuffer))
		{
			return(1);
		}

		return(0);//sucess
	}
	else
		return(0x20);//open endpoint failed
}
//6
DLLSPEC int _stdcall fw_changkey_4442(int icdev,unsigned char _Adr,int rlen,
									  unsigned char *key)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;

		temp[1]=CARD4442SENTTITLE1;
		temp[2]=CARD4442SENTTITLE2;
		temp[3]=0x70;
		temp[4]=0x06;
		//data
		temp[5]=0x76;
		temp[6]=0x00;
	//	temp[7]=(unsigned char)rlen;//rlen=3
		temp[7]=0x03;

		for(int j=0;j<3;j++)
		{
			temp[8+j]=*(key++);
		}
		
		//get and set xor buffer
		unsigned char xorbuffer=0;
		for(int i=2;i<11;i++)
		{
			xorbuffer^=temp[i];
		}
		temp[11]=xorbuffer;

		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed

		return(0);//sucess
	}
	else
		return(0x20);//open endpoint failed
}
//7
DLLSPEC int _stdcall fw_cntReadError_4442(int icdev,unsigned char *cntReadError)
{
	if(icdev)
	{
		HANDLE hDev=(HANDLE)icdev;
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;

		temp[1]=CARD4442SENTTITLE1;
		temp[2]=CARD4442SENTTITLE2;
		temp[3]=0x70;
		temp[4]=0x03;
		//data
		temp[4]=0x77;
		temp[5]=0x00;
		temp[6]=0x00;
		//get and set xor buffer
		unsigned char xorbuffer=0;
		for(int i=0;i<7;i++)
		{
			xorbuffer^=temp[i];
		}
		temp[7]=xorbuffer;

		//sent and get feature 
		HidD_SetFeature(hDev,temp,0x21);
		HidD_GetFeature(hDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed 

		*cntReadError=OutReport[5];

		return(0);//sucess
	}
	else
		return (0x20);//open endpoint failed
}
//-----------------------------------------------
//-------------4442 Commond Functions(up)
//-----------------------------------------------




//-----------------------------------------------
//-------------cup(SAM)  Functions(down)
//-----------------------------------------------
//1
DLLSPEC __int16 fw_cpureset(HANDLE ICDev,unsigned char *rlen, unsigned char *rbuff)
{
	if(ICDev)
	{
		unsigned char temp[255];
		unsigned char OutReport[255];

		memset(temp,0,255);
		OutReport[0]=0;
		temp[1]=CPUSENTTITLE1;
		temp[2]=CPUSENTTITLE2;
		temp[3]=0x7e;
		temp[4]=0x00;

		//get and set the xor buffer
		unsigned xorbuffer=0x00;
		for(int i=2;i<5;i++)
		{
			xorbuffer^=temp[i];
		}
		temp[5]=xorbuffer;

		//set and get feature data
		HidD_SetFeature(ICDev,temp,0x21);
		HidD_GetFeature(ICDev,OutReport,0x21);
		if(OutReport[3])
			return (OutReport[3]);//call failed
		int returnlen=(int)OutReport[4]-1;
		*rlen=(unsigned char)(returnlen);


		for(int k=0;k<returnlen;k++)
		{
			*(rbuff++)=OutReport[6+k];
		}


		return(0);//sucess
	}
	else
		return(0x20);//open endpoint failed
}
//2
DLLSPEC __int16 fw_setcpu(HANDLE ICDev,unsigned char SAMID)
{
	if(ICDev)
	{
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;
		temp[1]=CPUSENTTITLE1;
		temp[2]=CPUSENTTITLE2;
		temp[3]=0x83;
		temp[4]=0x01;
		//data
		temp[5]=SAMID;

		//get and set xorbuffer
		unsigned xorbuffer=0x00;
		for(int i=2;i<6;i++)
		{
			xorbuffer^=temp[i];
		}
		temp[6]=xorbuffer;
		//send and get feature data
		HidD_SetFeature(ICDev,temp,0x21);
		HidD_GetFeature(ICDev,OutReport,0x21);
		if(OutReport[3])
			return(OutReport[3]);//call failed 

		return (0);//sucess
	}
	else
		return (0x20);//open endpoint failed
}

//3
DLLSPEC __int16 fw_cpuapdu(HANDLE ICDev,unsigned char slen,unsigned char * sbuff,
				   unsigned char *rlen,unsigned char * rbuff)
{

	if(ICDev)
	{
		if(slen<=27)
		{
			unsigned char temp[255];
			unsigned char OutReport[255];

			memset(temp,0,255);
			OutReport[0]=0;
			temp[1]=CPUSENTTITLE1;
			temp[2]=CPUSENTTITLE2;
			temp[3]=0x7d;
			temp[4]=slen+1;

			//data
			temp[5]=slen;

			for(int j=6;j<6+slen;j++)
			{
				temp[j]=*(sbuff++);
			}

			
			//get and set xorbuffer
			unsigned xorbuffer=0x00;
			for(int i=2;i<j;i++)
			{
				xorbuffer^=temp[i];
			}
			temp[j]=xorbuffer;

			//send and get feature data
			HidD_SetFeature(ICDev,temp,0x21);
			HidD_GetFeature(ICDev,OutReport,0x21);
			if(OutReport[3])
				return(OutReport[3]);//call failed 

			//get return data
			int returnlen=(int)OutReport[4]-1;
			*rlen=(unsigned char)(returnlen);
			
			if(0x02==OutReport[1])
			{

				for(int l=0;l<returnlen;l++)
				{
					*(rbuff++)=OutReport[6+l];
				}
			}
			else if(0x82==OutReport[1])
			{
				int getTime=0;
				int iData=0;//the current count of out feature data
				getTime=returnlen/30+1;

				//the first time get feature
				for(int l=0;l<27;l++)
				{
					*(rbuff++)=OutReport[6+l];
					++iData;
				}

				getTime--;
				//loop to get Feature data
				while(getTime>=1)
				{
					if(getTime!=1)
					{
						HidD_GetFeature(ICDev,OutReport,0x21);
						for(int i=0;i<31;i++)
						{
							*(rbuff++)=OutReport[2+i];
							++iData;
						}
						
						getTime--;
					}
					else//the last time to get feature data
					{
						int ltimelen=returnlen-iData;

						HidD_GetFeature(ICDev,OutReport,0x21);
						for(int i=0;i<ltimelen;i++)
						{
							*(rbuff++)=OutReport[2+i];
						}
						getTime--;
					}
				}



			}
			return (0);//sucess
		}//if(slen<=24)
		else
		{
			unsigned char temp[255];
			unsigned char OutReport[255];

			memset(temp,0,255);
			OutReport[0]=0;

			int itemp=0;//count of xorbuffer
			int sentTime=0;
			sentTime=(slen/32)+1;

			//the first time sent feature
			unsigned char singletemp[255];
			memset(singletemp,0,255);
			
			singletemp[1]=CPUOVERFLOWTITLE1;
			singletemp[2]=temp[++itemp]=CPUSENTTITLE2;
			singletemp[3]=temp[++itemp]=0x7d;
			singletemp[4]=temp[++itemp]=slen+1;
			//data
			singletemp[5]=temp[++itemp]=slen;
			
			
			for(int k=0;k<27;k++)
			{
				singletemp[6+k]=temp[++itemp]=*(sbuff++);
			}
			
			slen-=27;
			//sent feature time:1
			HidD_SetFeature(ICDev,singletemp,0x21);
			
			sentTime--;

			//loop to sent feature
			while(sentTime)
			{


				if(sentTime!=1)
				{
					unsigned char stemp[255];
					memset(stemp,0,255);

					stemp[1]=CPUOVERFLOWTITLE1;
				//	stemp[1]=temp[++itemp]=CPUOVERFLOWTITLE1;

					//data


					for(int k=0;k<31;k++)
					{
						stemp[2+k]=temp[++itemp]=*(sbuff++);
					}

					slen-=31;
					//sent feature time:1
					HidD_SetFeature(ICDev,stemp,0x21);

					sentTime--;
				}
				else//sentTime=1
				{
					unsigned char lasttemp[255];
					memset(lasttemp,0,255);

				//	lasttemp[1]=temp[++itemp]=CPUSENTTITLE1;
					lasttemp[1]=CPUSENTTITLE1;

					//data

					int remainlen=strlen((char *)sbuff);


					for(int k=0;k<slen;k++)
					{
						lasttemp[2+k]=temp[++itemp]=*(sbuff++);
					}

					//get and set xorbuffer
					unsigned xorbuffer=0x00;
					for(int i=0;i<itemp+1;i++)
					{
						xorbuffer^=temp[i];
					}
					lasttemp[2+k]=xorbuffer;
					//sent feature time:1
					sentTime--;

					HidD_SetFeature(ICDev,lasttemp,0x21);
					HidD_GetFeature(ICDev,OutReport,0x21);
					if(OutReport[3])
						return (OutReport[3]);//call failed

					int returnlen=(int)OutReport[4]-1;
					*rlen=(unsigned char)(returnlen);

					//get the return buffer data
					for(int l=0;l<returnlen;l++)
					{
						*(rbuff++)=OutReport[6+l];
					}

					return (0);//sucess

				}


			}//while(sentTime)

		}

		return(0);
	}//if(ICDev)
	else
		return (0x20);//open endpoint failed
}
//4
DLLSPEC __int16 fw_cpuapdusource(HANDLE ICDev,unsigned char slen,unsigned char * sbuff,
						 unsigned char *rlen,unsigned char * rbuff)
{
	return (0);
}
//5
DLLSPEC __int16 fw_setcpupara(HANDLE ICDev,unsigned char cputype,unsigned char cpupro,
					  unsigned char cpuetu)
{
	if(ICDev)
	{
		unsigned char temp[255];
		unsigned char OutReport[255];
		memset(temp,0,255);
		OutReport[0]=0;
		temp[1]=CPUSENTTITLE1;
		temp[2]=CPUSENTTITLE2;
		temp[3]=0xe9;
		temp[4]=0x03;
		//data
		temp[5]=cpupro;//prototol of card 
		temp[6]=cpuetu;//time parameter 
		temp[7]=cputype;
		//get and set xorbuffer
		unsigned xorbuffer=0x00;
		for(int i=2;i<8;i++)
		{
			xorbuffer^=temp[i];
		}
		temp[8]=xorbuffer;
		//send and get feature data
		HidD_SetFeature(ICDev,temp,0x21);
		HidD_GetFeature(ICDev,OutReport,0x21);
		if(OutReport[3])
			return(OutReport[3]);//call failed 

		return (0);//sucess
	}
	else
		return (0x20);//open endpoint failed
}
//-----------------------------------------------
//-------------cup(SAM)  Functions(up)
//-----------------------------------------------



/**********Expetion Function************/
void Gen_Childkey1(unsigned char Key[8],unsigned char Childkey[16][48])
{
	__int16 pc_1[] =	{
			57,49,41,33,25,17,9 ,
			1 ,58,50,42,34,26,18,
			10,2 ,59,51,43,35,27,
			19,11,3 ,60,52,44,36,
			63,55,47,39,31,23,15,
			7 ,62,54,46,38,30,22,
			14,6 ,61,53,45,37,29,
			21,13,5 ,28,20,12,4
			};
	__int16 sht[] = 	{
			1 ,1 ,2 ,2 ,2 ,2 ,2 ,2 , 1 ,2 ,2 ,2 ,2 ,2 ,2 ,1
			};
	__int16 pc_2[] =	{
			14,17,11,24,1 ,5 ,
			3 ,28,15,6 ,21,10,
			23,19,12,4 ,26,8 ,
			16,7 ,27,20,13,2 ,
			41,52,31,37,47,55,
			30,40,51,45,33,48,
			44,49,39,56,34,53,
			46,42,50,36,29,32
			};
	__int16 i,j,k;
	unsigned char pc_1t[56],temp;
	unsigned char keybit[64];
	Char_Bit(Key,8,keybit);
	for(i=0;i<56;i++)                       //pc-1
		pc_1t[i]=keybit[pc_1[i]-1];
	for(k=0;k<16;k++)
		{
		for(i=0;i<sht[k];i++)
			{			//c1, d1
			temp=pc_1t[0];
			for(j=0;j<28;j++)
				if(j==27)	pc_1t[j]=temp;
				else		pc_1t[j]=pc_1t[j+1];

			temp=pc_1t[28];
			for(j=28;j<56;j++)
				if(j==55)	pc_1t[j]=temp;
				else		pc_1t[j]=pc_1t[j+1];
			}
		for(i=0;i<48;i++)		//pc-2
			Childkey[k][i]=pc_1t[pc_2[i]-1];
		}
}

void Gen_Childkey2(unsigned char key[8],unsigned char child_key[16][6])
{
	__int16 pc_1[] =	{
			57,49,41,33,25,17,9 ,
			1 ,58,50,42,34,26,18,
			10,2 ,59,51,43,35,27,
			19,11,3 ,60,52,44,36,
			63,55,47,39,31,23,15,
			7 ,62,54,46,38,30,22,
			14,6 ,61,53,45,37,29,
			21,13,5 ,28,20,12,4
			};
	__int16 sht[] = 	{
			1 ,1 ,2 ,2 ,2 ,2 ,2 ,2 , 1 ,2 ,2 ,2 ,2 ,2 ,2 ,1
			};
	__int16 pc_2[] =	{
			14,17,11,24,1 ,5 ,
			3 ,28,15,6 ,21,10,
			23,19,12,4 ,26,8 ,
			16,7 ,27,20,13,2 ,
			41,52,31,37,47,55,
			30,40,51,45,33,48,
			44,49,39,56,34,53,
			46,42,50,36,29,32
			};
	__int16 i,j,k;
	unsigned char pc_1t[56],temp;
	unsigned char keybit[64];
	unsigned char childkey[16][48];
	Char_Bit(key,8,keybit);
	for(i=0;i<56;i++)                       //pc-1
		pc_1t[i]=keybit[pc_1[i]-1];
	for(k=0;k<16;k++){
		for(i=0;i<sht[k];i++)
			{		//c1, d1
			temp=pc_1t[0];
			for(j=0;j<28;j++)
				if(j==27)	pc_1t[j]=temp;
				else		pc_1t[j]=pc_1t[j+1];

			temp=pc_1t[28];
			for(j=28;j<56;j++)
				if(j==55)	pc_1t[j]=temp;
				else		pc_1t[j]=pc_1t[j+1];

			}
		for(i=0;i<48;i++)		//pc-2
			childkey[k][i]=pc_1t[pc_2[i]-1];
		}
	for(i=0;i<16;i++)
		for(j=0;j<6;j++)	Bit_Char(childkey[i],48,child_key[i]);
}

void Bit_Char(unsigned char *Src,__int16 BitLen,unsigned char *Res)
{    
	__int16 i,j,a;
	for(i=0;i<(BitLen/8);i++)
	{
		a=128;
		Res[i]=0x00;
		for(j=0;j<8;j++)
		{
			Res[i]=Res[i]+Src[j+i*8]*a;
			//*(Res++)=Res[i]+Src[j+i*8]*a;
			a/=2;
		}
	}
}

void Char_Bit(unsigned char *Src,__int16 CharLen,unsigned char *Res)
{      
	__int16 i,j;
	unsigned char temp;
	for(i=0;i<CharLen;i++)
		for(j=0;j<8;j++){
			temp=(Src[i]<<j)&0x80;
			if(temp)	Res[i*8+j]=0x01;
			else		Res[i*8+j]=0x00;
			}
	return;
}
